$(document).ready(function() {
    
    // Función para cargar y mostrar el inventario
    function cargarInventario() {
        $.ajax({
            url: 'php_logic/listar_inventario.php',
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                const tbody = $('#tabla_inventario_body');
                tbody.empty(); 

                if (data.length === 0) {
                    tbody.append('<tr><td colspan="6" class="text-center">No hay inventario registrado.</td></tr>');
                    return;
                }

                data.forEach(item => {
                    const seFacturaChecked = item.sefactura == 1 ? 'checked' : '';
                    const fila = `
                        <tr data-lote-id="${item.lote_id}">
                            <td>
                                <strong>${item.NombreComercial}</strong><br>
                                <small class="text-muted">${item.laboratorio}</small>
                            </td>
                            <td>
                                <small>Int: ${item.CodigoInterno}</small><br>
                                <span class="dato-codigobarra">${item.CodigoBarraLote || 'N/A'}</span>
                            </td>
                            <td>
                                <small>Lote: ${item.codigo_lote}</small><br>
                                <span class="dato-fechavencimiento">${item.fechavencimiento}</span>
                            </td>
                            <td class="dato-sefactura" data-valor="${item.sefactura}">
                                <input type="checkbox" ${seFacturaChecked} disabled>
                            </td>
                            <td><strong>${item.stock_unidad_base}</strong></td>
                            <td class="acciones">
                                <button class="btn btn-sm btn-warning btn-editar">Editar</button>
                            </td>
                        </tr>
                    `;
                    tbody.append(fila);
                });
            },
            error: function() {
                $('#tabla_inventario_body').html('<tr><td colspan="6" class="text-center text-danger">Error al cargar el inventario.</td></tr>');
            }
        });
    }

    // --- LÓGICA DE BÚSQUEDA EN TIEMPO REAL ---
    $('#buscador_inventario').on('keyup', function() {
        const textoBusqueda = $(this).val().toLowerCase();
        $('#tabla_inventario_body tr').filter(function() {
            $(this).toggle($(this).text().toLowerCase().indexOf(textoBusqueda) > -1)
        });
    });

    // --- LÓGICA DE EDICIÓN ---
    // 1. Al hacer clic en "Editar"
    $(document).on('click', '.btn-editar', function() {
        const fila = $(this).closest('tr');
        fila.addClass('fila-edicion'); // Resaltar fila

        // Convertir campos a inputs
        const vencimientoActual = fila.find('.dato-fechavencimiento').text();
        fila.find('.dato-fechavencimiento').html(`<input type="date" class="form-control form-control-sm" value="${vencimientoActual}">`);

        const codBarraActual = fila.find('.dato-codigobarra').text();
        fila.find('.dato-codigobarra').html(`<input type="text" class="form-control form-control-sm" value="${codBarraActual === 'N/A' ? '' : codBarraActual}">`);

        const seFacturaActual = fila.find('.dato-sefactura').data('valor') == 1;
        fila.find('.dato-sefactura').html(`<input type="checkbox" class="form-check-input" ${seFacturaActual ? 'checked' : ''}>`);
        
        // Cambiar botones
        fila.find('.acciones').html(`
            <button class="btn btn-sm btn-success btn-guardar-cambios">Guardar</button>
            <button class="btn btn-sm btn-secondary btn-cancelar-edicion">Cancelar</button>
        `);
    });

    // 2. Al hacer clic en "Cancelar"
    $(document).on('click', '.btn-cancelar-edicion', function() {
        cargarInventario(); // La forma más fácil de revertir es recargar todo
    });

    // 3. Al hacer clic en "Guardar Cambios"
    $(document).on('click', '.btn-guardar-cambios', function() {
        const fila = $(this).closest('tr');
        const loteId = fila.data('lote-id');
        
        const datosActualizados = {
            lote_id: loteId,
            fechavencimiento: fila.find('input[type="date"]').val(),
            codigobarra: fila.find('input[type="text"]').val(),
            sefactura: fila.find('input[type="checkbox"]').is(':checked') ? 1 : 0,
        };

        // Enviar datos por Ajax para actualizar
        $.ajax({
            url: 'php_logic/actualizar_lote.php',
            type: 'POST',
            data: datosActualizados,
            dataType: 'json',
            success: function(response) {
                if(response.success) {
                    alert('¡Actualizado con éxito!');
                    cargarInventario(); // Recargamos para ver los cambios
                } else {
                    alert('Error al actualizar: ' + response.message);
                }
            },
            error: function() {
                alert('Error de conexión al intentar guardar.');
            }
        });
    });

    // Carga inicial del inventario
    cargarInventario();
});