<?php
require_once 'php/config.php';
// Obtenemos los usuarios de ESTA sucursal para el dropdown de "Quién recibe"
$usuarios_reciben_aqui = obtenerUsuariosRecibe($pdo);
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Recepción de Traslados - Sufarma v3</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="icon" href="data:image/svg+xml,<svg xmlns=%22http://www.w3.org/2000/svg%22 viewBox=%220 0 100 100%22><text y=%22.9em%22 font-size=%2290%22>📥</text></svg>">
</head>
<body>

<nav class="navbar navbar-expand-lg navbar-dark bg-success shadow-sm">
    <div class="container">
        <a class="navbar-brand" href="traslados.php">Sufarma v3</a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav">
                <li class="nav-item">
                    <a class="nav-link active" aria-current="page" href="traslados.php">Registrar Traslado</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="ver_traslados.php">Ver Traslados</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="recepcion.php">Recepción <span class="badge bg-warning text-dark">!</span></a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="https://sufarmasanfe.farmaciasjireh.com/index_simplificado.php">Regresar a Ventas </a>
                </li>
            </ul>
        </div>
    </div>
</nav>

<div class="container my-4">
    <div class="card shadow-sm mt-4">
        <div class="card-header bg-warning text-dark">
            <h4 class="mb-0">Bandeja de Recepción (<?php echo NOMBRE_SUCURSAL_ACTUAL; ?>)</h4>
        </div>
        <div class="card-body">
            <p class="text-muted">Mostrando traslados pendientes de aceptar en esta sucursal.</p>
            <div class="table-responsive">
                <table class="table table-sm table-hover align-middle">
                    <thead class="table-light sticky-top">
                        <tr>
                            <th>Producto</th>
                            <th>Cant./Present.</th>
                            <th>Facturable</th>
                            <th>Origen</th>
                            <th>Envió</th>
                            <th style="width: 18%;">Recibido Por (Yo)</th>
                            <th style="width: 20%;">Acción</th>
                        </tr>
                    </thead>
                    <tbody id="tabla_recepcion_traslados">
                        <tr><td colspan="7" class="text-center text-muted">Cargando traslados pendientes...</td></tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div id="alerta-notificacion" class="alert alert-success d-none position-fixed bottom-0 end-0 m-3 shadow-lg" role="alert"></div>
</div>

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
    const AppData = {
        usuariosRecibenAqui: <?php echo json_encode($usuarios_reciben_aqui); ?>
    };
</script>
<script src="js/recepcion.js"></script>

</body>
</html>