<?php
/**
 * API: Establecer Sucursal Actual
 * Actualiza la configuración de la sucursal activa
 */

header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json; charset=utf-8');

require_once '../config/database.php';
require_once '../config/branch.php';

// Solo permitir POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendJSON(['success' => false, 'error' => 'Método no permitido'], 405);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);

if (!isset($data['sucursal_id'])) {
    sendJSON(['success' => false, 'error' => 'ID de sucursal requerido'], 400);
    exit;
}

$branchId = (int)$data['sucursal_id'];

try {
    // Verificar que la sucursal existe
    $pdo = getDBConnection();
    $stmt = $pdo->prepare("SELECT id FROM sucursales WHERE id = ?");
    $stmt->execute([$branchId]);
    
    if (!$stmt->fetch()) {
        sendJSON(['success' => false, 'error' => 'La sucursal no existe'], 404);
        exit;
    }
    
    // Guardar configuración
    if (setCurrentBranchId($branchId)) {
        sendJSON(['success' => true, 'message' => 'Sucursal actualizada correctamente']);
    } else {
        sendJSON(['success' => false, 'error' => 'Error al guardar configuración'], 500);
    }
    
} catch (PDOException $e) {
    error_log("Error al establecer sucursal: " . $e->getMessage());
    sendJSON(['success' => false, 'error' => 'Error de base de datos'], 500);
}
