<?php
/**
 * API: Obtener Usuarios
 * Retorna lista de usuarios activos del sistema
 */

header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json; charset=utf-8');

require_once '../config/database.php';

try {
    $pdo = getDBConnection();
    
    require_once '../config/branch.php';
    $sucursal_id = getCurrentBranchId();

    $whereClause = "";
    
    // Filtrar usuarios por sucursal
    $ids = [];
    switch ($sucursal_id) {
        case 2:
            $ids = [7, 8, 10];
            break;
        case 3:
            $ids = [5, 6, 11];
            break;
        case 4:
            $ids = [9];
            break;
        case 5:
            $ids = [3, 4, 11];
            break;
    }

    if (!empty($ids)) {
        $idsStr = implode(',', $ids);
        $whereClause = "WHERE u.id IN ($idsStr)";
    }

    $sql = "SELECT 
                u.id,
                u.codigo_usuario,
                u.usuario,
                u.nombre,
                u.tipo_usuario_id,
                t.nombre as tipo_usuario
            FROM usuarios u
            LEFT JOIN tipousuario t ON t.id = u.tipo_usuario_id
            $whereClause
            ORDER BY u.nombre ASC";
    
    $stmt = $pdo->query($sql);
    $usuarios = $stmt->fetchAll();
    
    sendJSON([
        'success' => true,
        'data' => $usuarios
    ]);
    
} catch (PDOException $e) {
    error_log("Error al obtener usuarios: " . $e->getMessage());
    sendJSON(['success' => false, 'error' => 'Error al obtener usuarios'], 500);
}
