<?php
/**
 * API: Eliminar Detalle de Pedido
 * Elimina un producto específico del historial de pedidos
 */

header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json; charset=utf-8');

require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/branch.php';

// Solo permitir POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendJSON(['success' => false, 'error' => 'Método no permitido'], 405);
}

try {
    $pdo = getDBConnection();
    
    // Obtener datos
    $input = file_get_contents('php://input');
    $data = json_decode($input, true);
    
    if (!isset($data['detalle_id'])) {
        sendJSON(['success' => false, 'error' => 'ID de detalle requerido'], 400);
    }
    
    $detalle_id = intval($data['detalle_id']);
    $sucursal_id = getCurrentBranchId();
    
    // Verificar que el detalle pertenezca a un pedido PENDIENTE de esta sucursal
    // (Por seguridad, no permitimos borrar cosas de pedidos ya enviados/finalizados)
    $sqlCheck = "SELECT dp.id 
                 FROM detalle_pedidos dp
                 INNER JOIN pedidos p ON dp.pedido_id = p.id
                 WHERE dp.id = :detalle_id 
                 AND p.sucursal_id = :sucursal_id 
                 AND p.estado = 'pendiente'";
                 
    $stmtCheck = $pdo->prepare($sqlCheck);
    $stmtCheck->execute([
        ':detalle_id' => $detalle_id,
        ':sucursal_id' => $sucursal_id
    ]);
    
    if (!$stmtCheck->fetch()) {
        sendJSON(['success' => false, 'error' => 'No se puede eliminar: El pedido no existe o ya fue procesado'], 403);
    }
    
    // Proceder a eliminar
    $sqlDelete = "DELETE FROM detalle_pedidos WHERE id = :detalle_id";
    $stmtDelete = $pdo->prepare($sqlDelete);
    $stmtDelete->execute([':detalle_id' => $detalle_id]);
    
    sendJSON(['success' => true, 'message' => 'Producto eliminado correctamente']);
    
} catch (PDOException $e) {
    error_log("Error al eliminar detalle: " . $e->getMessage());
    sendJSON(['success' => false, 'error' => 'Error de base de datos'], 500);
}