<?php
// imprimir_ticket_factura.php
date_default_timezone_set('America/Guatemala');
include 'db_connection.php';
include 'sucursal_config.php';

// Recibir el ID de la venta
$venta_id = isset($_GET['venta_id']) ? intval($_GET['venta_id']) : 0;

if ($venta_id <= 0) {
    die('Venta inválida');
}

// Obtener información de la venta
$sqlVenta = "SELECT v.id, v.total, v.fecha_y_hora, s.nombre as sucursal_nombre
            FROM ventas v
            JOIN sucursales s ON v.sucursal_id = s.id
            WHERE v.id = ? AND v.sucursal_id = ?";
$stmtVenta = $conn->prepare($sqlVenta);
$stmtVenta->bind_param("ii", $venta_id, $sucursal_id);
$stmtVenta->execute();
$venta = $stmtVenta->get_result()->fetch_assoc();

if (!$venta) {
    die('Venta no encontrada');
}

// Obtener detalles de la venta
$sqlDetalle = "SELECT dv.cantidad, dv.precio, dv.subtotal, dv.facturado, dv.estado_factura,
               p.NombreComercial, p.laboratorio
               FROM detalle_ventas dv
               JOIN productos p ON dv.producto_id = p.id
               WHERE dv.venta_id = ?";
$stmtDetalle = $conn->prepare($sqlDetalle);
$stmtDetalle->bind_param("i", $venta_id);
$stmtDetalle->execute();
$detalles = $stmtDetalle->get_result();

// Generar HTML del ticket
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Ticket #<?php echo $venta_id; ?></title>
    <style>
        @page {
            size: 80mm auto;
            margin: 0;
        }
        body {
            font-family: 'Courier New', monospace;
            margin: 0 auto;
            padding: 0;
            font-size: 10px;
            line-height: 1.2;
            width: 80mm;
            text-align: center;
            font-weight: bold;
        }
        .ticket {
            width: 100%;
            padding: 1mm;
        }
        .header {
            text-align: center;
            margin-bottom: 3px;
            font-size: 9px;
        }
        .logo {
            max-width: 50%;
            height: auto;
            margin: 0 auto;
            display: block;
            margin-bottom: 5px;
        }
        .header h2 {
            margin: 0;
            font-size: 12px;
        }
        .header p {
            margin: 1px 0;
        }
        .detalle {
            width: 90%;
            border-collapse: collapse;
            margin: 3px auto;
        }
        .detalle th {
            font-size: 9px;
            padding: 1px;
            text-align: left;
            border-bottom: 1px dotted #000;
        }
        .detalle td {
            padding: 1px;
            font-size: 9px;
            font-weight: bold;
        }
        .detalle .cant { width: 10%; text-align: center; }
        .detalle .prod { width: 50%; text-align: left; }
        .detalle .precio { width: 20%; text-align: right; }
        .detalle .subt { width: 20%; text-align: right; }
        .total {
            text-align: right;
            margin-top: 3px;
            border-top: 1px dotted #000;
            padding-top: 2px;
            font-size: 11px;
            font-weight: 900;
        }
        .total strong {
            display: inline-block;
            margin-right: 10mm; /* Mueve solo el texto del total */
        }
        @media print {
            body { margin: 0; padding: 0; }
            .no-print { display: none; }
        }
    </style>
</head>
<body>
    <div class="ticket">
        <div class="header">
            <img src="logo/Logo Positivo - Horizonal.png" alt="Logo Farmacia" class="logo">
            <p><?php echo htmlspecialchars($venta['sucursal_nombre']); ?></p>
            <p>#<?php echo $venta_id; ?> - <?php echo date('d/m/Y H:i', strtotime($venta['fecha_y_hora'])); ?></p>
        </div>

        <table class="detalle">
            <thead>
                <tr>
                    <th class="cant">Cant</th>
                    <th class="prod">Producto</th>
                    <th class="precio">Precio</th>
                    <th class="subt">Subt</th>
                </tr>
            </thead>
            <tbody>
                <?php while ($item = $detalles->fetch_assoc()): ?>
                <tr>
                    <td class="cant"><?php echo $item['cantidad']; ?></td>
                    <td class="prod"><?php echo htmlspecialchars($item['NombreComercial']); ?></td>
                    <td class="precio"><?php echo number_format($item['precio'], 2); ?></td>
                    <td class="subt"><?php echo number_format($item['subtotal'], 2); ?></td>
                </tr>
                <?php endwhile; ?>
            </tbody>
        </table>

        <div class="total">
            <strong>Total: Q<?php echo number_format($venta['total'], 2); ?></strong>
        </div>

        <div class="header">
            <p>¡Gracias por su compra!</p>
        </div>

        <div class="no-print">
            <button onclick="window.print()">Imprimir Ticket</button>
            <button onclick="window.close()">Cerrar</button>
        </div>
    </div>
</body>
</html>
