<?php
// delete_sale.php
date_default_timezone_set('America/Guatemala'); // Ajusta la zona horaria según tu ubicación
include 'db_connection.php';
include 'sucursal_config.php';


// 1. Recibir datos por POST
$venta_id = isset($_POST['venta_id']) ? intval($_POST['venta_id']) : 0;
$tipo     = isset($_POST['tipo']) ? $_POST['tipo'] : '';

if ($venta_id <= 0 || empty($tipo)) {
    echo json_encode([
        'success' => false,
        'message' => 'Datos inválidos.'
    ]);
    exit;
}

$conn->begin_transaction();

try {
    if ($tipo === 'Normal') {
        // Eliminar detalles de la venta normal (sin sucursal_id)
        $sqlDeleteDetalles = "DELETE FROM detalle_ventas WHERE venta_id = ?";
        $stmtDetalles = $conn->prepare($sqlDeleteDetalles);
        if (!$stmtDetalles) {
            throw new Exception('Error en la preparación de la consulta de detalles: ' . $conn->error);
        }
        $stmtDetalles->bind_param("i", $venta_id);
        if (!$stmtDetalles->execute()) {
            throw new Exception('Error al eliminar los detalles de la venta normal: ' . $stmtDetalles->error);
        }

        // Eliminar la venta normal (con sucursal_id para seguridad)
        $sqlDeleteVenta = "DELETE FROM ventas WHERE id = ? AND sucursal_id = ?";
        $stmtVenta = $conn->prepare($sqlDeleteVenta);
        if (!$stmtVenta) {
            throw new Exception('Error en la preparación de la consulta de venta: ' . $conn->error);
        }
        $stmtVenta->bind_param("ii", $venta_id, $sucursal_id);
        if (!$stmtVenta->execute()) {
            throw new Exception('Error al eliminar la venta normal: ' . $stmtVenta->error);
        }

    } elseif ($tipo === 'Especial') {
        // Eliminar la venta especial
        $sqlDeleteEspecial = "DELETE FROM ventas_especiales WHERE id = ? AND sucursal_id = ?";
        $stmtEspecial = $conn->prepare($sqlDeleteEspecial);
        if (!$stmtEspecial) {
            throw new Exception('Error en la preparación de la consulta de venta especial: ' . $conn->error);
        }
        $stmtEspecial->bind_param("ii", $venta_id, $sucursal_id);
        if (!$stmtEspecial->execute()) {
            throw new Exception('Error al eliminar la venta especial: ' . $stmtEspecial->error);
        }

    } else {
        throw new Exception('Tipo de venta inválido.');
    }

    $conn->commit();

    echo json_encode([
        'success' => true,
        'message' => 'Venta eliminada exitosamente.'
    ]);

} catch (Exception $e) {
    $conn->rollback();
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}

$conn->close();
?>
