$(document).ready(function() {
    
    // --- Función para construir el Dropdown de Usuarios ---
    function construirSelectUsuarios() {
        let html = `<select class='form-select form-select-sm' name='usuario_recibe_final'>`;
        AppData.usuariosRecibenAqui.forEach(user => {
            html += `<option value="${user.id}">${user.nombre}</option>`;
        });
        html += `</select>`;
        return html;
    }

    // --- Cargar la lista de traslados pendientes ---
    function cargarRecepciones() {
        const tablaRecepcion = $('#tabla_recepcion_traslados');
        const selectUsuariosHTML = construirSelectUsuarios();

        $.ajax({
            type: 'GET',
            url: 'php/listar_recepciones.php',
            data: {
                // Pasamos el HTML del select para que el PHP lo inserte
                select_html: selectUsuariosHTML
            },
            beforeSend: function() {
                tablaRecepcion.html("<tr><td colspan='7' class='text-center'><div class='spinner-border spinner-border-sm'></div> Cargando...</td></tr>");
            },
            success: function(response) {
                tablaRecepcion.html(response || "<tr><td colspan='7' class='text-center'>No hay traslados pendientes.</td></tr>");
            },
            error: function() {
                tablaRecepcion.html("<tr><td colspan='7' class='text-center text-danger'>Error al cargar la bandeja.</td></tr>");
            }
        });
    }

    // Carga inicial
    cargarRecepciones();

    // --- Acción de Aceptar o Rechazar ---
    function manejarAccionTraslado(boton, nuevoEstado) {
        let fila = boton.closest('tr');
        let traslado_id = boton.data('id');
        let usuario_recibe_id = fila.find('select[name="usuario_recibe_final"]').val();

        if (!usuario_recibe_id) {
            mostrarNotificacion('Error: Debe seleccionar quién recibe.', 'danger');
            return;
        }

        // Deshabilitar botones para evitar doble click
        fila.find('.btn-accion').prop('disabled', true).html('<span class="spinner-border spinner-border-sm"></span>');

        $.ajax({
            type: 'POST',
            url: 'php/actualizar_estado_traslado.php',
            data: {
                traslado_id: traslado_id,
                usuario_recibe_id: usuario_recibe_id,
                nuevo_estado: nuevoEstado // 'completado' o 'cancelado'
            },
            dataType: 'json',
            success: function(response) {
                if(response.status === 'success') {
                    mostrarNotificacion(response.message, 'success');
                    // Ocultar la fila procesada
                    fila.fadeOut(500, function() { $(this).remove(); });
                } else {
                    mostrarNotificacion('Error: ' + response.message, 'danger');
                    // Rehabilitar botones si falla
                    fila.find('.btn-accion').prop('disabled', false);
                    fila.find('.btn-aceptar').text('Aceptar');
                    fila.find('.btn-rechazar').text('Rechazar');
                }
            },
            error: function() {
                mostrarNotificacion('Error de conexión al actualizar.', 'danger');
                fila.find('.btn-accion').prop('disabled', false);
                fila.find('.btn-aceptar').text('Aceptar');
                fila.find('.btn-rechazar').text('Rechazar');
            }
        });
    }

    // Asignar eventos a los botones
    $('body').on('click', '.btn-aceptar', function() {
        manejarAccionTraslado($(this), 'completado');
    });

    $('body').on('click', '.btn-rechazar', function() {
        manejarAccionTraslado($(this), 'cancelado');
    });

    // Función para mostrar notificaciones
    function mostrarNotificacion(mensaje, tipo = 'success') {
        const alerta = $('#alerta-notificacion');
        alerta.removeClass('alert-success alert-danger').addClass(`alert-${tipo}`);
        alerta.text(mensaje).removeClass('d-none');
        setTimeout(() => alerta.addClass('d-none'), 4000);
    }
});