<?php
// update_special_sale.php
date_default_timezone_set('America/Guatemala'); // Ajusta la zona horaria según tu ubicación
include 'db_connection.php';
include 'sucursal_config.php';

// 1. Recibir datos por POST
$venta_id    = isset($_POST['venta_id']) ? intval($_POST['venta_id']) : 0;
$descripcion = isset($_POST['descripcion']) ? trim($_POST['descripcion']) : '';
$precio      = isset($_POST['precio']) ? floatval($_POST['precio']) : 0;

// Validar
if ($venta_id <= 0 || empty($descripcion) || $precio <= 0) {
    echo json_encode([
        'success' => false,
        'message' => 'Datos inválidos.'
    ]);
    exit;
}

// Actualizar la venta especial en la base de datos
$sqlUpdate = "UPDATE ventas_especiales 
              SET descripcion = ?, precio = ?
              WHERE id = ? AND sucursal_id = ?";
$stmt = $conn->prepare($sqlUpdate);
$stmt->bind_param("sdii", $descripcion, $precio, $venta_id, $sucursal_id);

if ($stmt->execute()) {
    echo json_encode([
        'success' => true,
        'message' => 'Venta especial actualizada exitosamente.'
    ]);
} else {
    echo json_encode([
        'success' => false,
        'message' => 'Error al actualizar la venta especial: ' . $stmt->error
    ]);
}

$stmt->close();
$conn->close();
?>
