-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Servidor: 127.0.0.1:3306
-- Tiempo de generación: 24-11-2025 a las 06:59:12
-- Versión del servidor: 9.1.0
-- Versión de PHP: 8.3.14

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Base de datos: `sufarma`
--

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `categorias`
--

DROP TABLE IF EXISTS `categorias`;
CREATE TABLE IF NOT EXISTS `categorias` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `clientes`
--

DROP TABLE IF EXISTS `clientes`;
CREATE TABLE IF NOT EXISTS `clientes` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nit` varchar(20) DEFAULT NULL,
  `nombre` varchar(100) NOT NULL,
  `telefono` varchar(15) DEFAULT NULL,
  `direccion` varchar(150) DEFAULT NULL,
  `tipo_cliente_id` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `tipo_cliente_id` (`tipo_cliente_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `compras`
--

DROP TABLE IF EXISTS `compras`;
CREATE TABLE IF NOT EXISTS `compras` (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `fecha_compra` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `id_lugarCompra` int NOT NULL,
  `total` decimal(10,2) NOT NULL,
  `tipo_pago` enum('contado','credito','mixto') NOT NULL,
  `monto_efectivo` decimal(10,2) DEFAULT NULL,
  `monto_credito` decimal(10,2) DEFAULT NULL,
  `fecha_limite_pago` date DEFAULT NULL,
  `estado_pago` enum('pendiente','pagado') NOT NULL DEFAULT 'pendiente',
  `imagen_factura` text,
  PRIMARY KEY (`id`),
  KEY `id_lugarCompra` (`id_lugarCompra`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `detalle_traslados`
--

DROP TABLE IF EXISTS `detalle_traslados`;
CREATE TABLE IF NOT EXISTS `detalle_traslados` (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `traslado_id` bigint UNSIGNED NOT NULL,
  `producto_id` bigint UNSIGNED NOT NULL,
  `cantidad_unidad` int DEFAULT '0',
  `cantidad_blister` int DEFAULT '0',
  `cantidad_caja` int DEFAULT '0',
  `sefactura` tinyint(1) NOT NULL DEFAULT '1' COMMENT '1=Facturable, 0=No Facturable',
  PRIMARY KEY (`id`),
  KEY `traslado_idx` (`traslado_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `detalle_ventas`
--

DROP TABLE IF EXISTS `detalle_ventas`;
CREATE TABLE IF NOT EXISTS `detalle_ventas` (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `venta_id` bigint UNSIGNED NOT NULL,
  `producto_id` bigint UNSIGNED NOT NULL,
  `cantidad` int NOT NULL,
  `precio` decimal(10,2) NOT NULL,
  `subtotal` decimal(10,2) NOT NULL,
  `lote_id` int DEFAULT NULL,
  `facturado` tinyint(1) DEFAULT '0',
  `estado_factura` enum('PENDIENTE','FACTURADO') DEFAULT 'PENDIENTE',
  PRIMARY KEY (`id`),
  KEY `lote_id` (`lote_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `ingresos_sucursal`
--

DROP TABLE IF EXISTS `ingresos_sucursal`;
CREATE TABLE IF NOT EXISTS `ingresos_sucursal` (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `producto_id` bigint UNSIGNED NOT NULL,
  `lote_id` int NOT NULL,
  `sucursal_id` int NOT NULL,
  `cantidad_ingresada` int NOT NULL,
  `presentacion_ingresada` enum('UNIDAD','BLISTER','CAJA') NOT NULL,
  `fecha_ingreso` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `usuario_entrega_id` int DEFAULT NULL COMMENT 'Usuario que transportó el producto',
  `usuario_recibe_id` int NOT NULL COMMENT 'Usuario que registró el ingreso en el sistema',
  `observaciones` text,
  `fecha_vencimiento_ingreso` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_producto` (`producto_id`),
  KEY `idx_sucursal` (`sucursal_id`),
  KEY `idx_lote` (`lote_id`),
  KEY `idx_usuario_recibe` (`usuario_recibe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='Bitácora de todos los ingresos de productos a sucursales';

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `inventario`
--

DROP TABLE IF EXISTS `inventario`;
CREATE TABLE IF NOT EXISTS `inventario` (
  `id` int NOT NULL AUTO_INCREMENT,
  `lote_id` int NOT NULL,
  `sucursal_id` int NOT NULL,
  `stock_unidad_base` int UNSIGNED NOT NULL DEFAULT '0',
  `presentacion` enum('UNIDAD','BLISTER','CAJA','BOTE','PAQUETE','FARDO','BOLSA','GALON') NOT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_lote_sucursal` (`lote_id`,`sucursal_id`),
  KEY `sucursal_id` (`sucursal_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `lote`
--

DROP TABLE IF EXISTS `lote`;
CREATE TABLE IF NOT EXISTS `lote` (
  `id` int NOT NULL AUTO_INCREMENT,
  `producto_id` int NOT NULL,
  `sefactura` tinyint(1) DEFAULT '1',
  `codigo_lote` varchar(100) NOT NULL,
  `codigobarra` varchar(100) DEFAULT NULL,
  `fechavencimiento` date NOT NULL,
  `fechacreacion` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_producto_lote` (`producto_id`,`codigo_lote`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `lugarcompra`
--

DROP TABLE IF EXISTS `lugarcompra`;
CREATE TABLE IF NOT EXISTS `lugarcompra` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nombre` varchar(220) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `productos`
--

DROP TABLE IF EXISTS `productos`;
CREATE TABLE IF NOT EXISTS `productos` (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `CodigoInterno` varchar(50) DEFAULT NULL,
  `CodigoBarra` varchar(50) DEFAULT NULL,
  `NombreComercial` varchar(255) DEFAULT NULL,
  `NombreGenerico` varchar(255) DEFAULT NULL,
  `id_categoria` int DEFAULT NULL,
  `FuncionMedica` text,
  `laboratorio` varchar(255) DEFAULT NULL,
  `id_lugarCompra` int DEFAULT NULL,
  `CostoMayor` decimal(10,2) DEFAULT NULL,
  `CostoMayorSinIva` decimal(10,2) DEFAULT NULL,
  `CostoBlister` decimal(10,2) DEFAULT NULL,
  `CostoBlisterSinIva` decimal(10,2) DEFAULT NULL,
  `CostoUnidad` decimal(10,2) DEFAULT NULL,
  `CostoUnidadSinIva` decimal(10,2) DEFAULT NULL,
  `CostoMixto` decimal(10,2) DEFAULT NULL,
  `CostoMixtoSinIva` decimal(10,2) DEFAULT NULL,
  `PrecioVentaUnidad` decimal(10,2) DEFAULT NULL,
  `PrecioVentaBlister` decimal(10,2) DEFAULT NULL,
  `PrecioVentaMayor` decimal(10,2) DEFAULT NULL,
  `PrecioVentaMixto` decimal(10,2) DEFAULT NULL,
  `FechaIngreso` date DEFAULT NULL,
  `FechaVencimiento` date NOT NULL,
  `imagen_producto` text,
  `id_presentacion` int DEFAULT NULL,
  `estado` tinyint(1) DEFAULT '1',
  `factor_conversion` int NOT NULL,
  `existencia` int NOT NULL,
  `exento_iva` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `id_categoria` (`id_categoria`),
  KEY `id_presentacion` (`id_presentacion`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Disparadores `productos`
--
DROP TRIGGER IF EXISTS `trg_productos_before_insert`;
DELIMITER $$
CREATE TRIGGER `trg_productos_before_insert` BEFORE INSERT ON `productos` FOR EACH ROW BEGIN
    SET NEW.CostoMayorSinIva   = IF(NEW.exento_iva = 1, NEW.CostoMayor, NEW.CostoMayor / 1.12);
    SET NEW.CostoBlisterSinIva = IF(NEW.exento_iva = 1, NEW.CostoBlister, NEW.CostoBlister / 1.12);
    SET NEW.CostoUnidadSinIva  = IF(NEW.exento_iva = 1, NEW.CostoUnidad, NEW.CostoUnidad / 1.12);
    SET NEW.CostoMixtoSinIva   = IF(NEW.exento_iva = 1, NEW.CostoUnidad, NEW.CostoUnidad / 1.12);
END
$$
DELIMITER ;
DROP TRIGGER IF EXISTS `trg_productos_before_update`;
DELIMITER $$
CREATE TRIGGER `trg_productos_before_update` BEFORE UPDATE ON `productos` FOR EACH ROW BEGIN
    SET NEW.CostoMayorSinIva   = IF(NEW.exento_iva = 1, NEW.CostoMayor, NEW.CostoMayor / 1.12);
    SET NEW.CostoBlisterSinIva = IF(NEW.exento_iva = 1, NEW.CostoBlister, NEW.CostoBlister / 1.12);
    SET NEW.CostoUnidadSinIva  = IF(NEW.exento_iva = 1, NEW.CostoUnidad, NEW.CostoUnidad / 1.12);
    SET NEW.CostoMixtoSinIva   = IF(NEW.exento_iva = 1, NEW.CostoUnidad, NEW.CostoUnidad / 1.12);
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `sucursales`
--

DROP TABLE IF EXISTS `sucursales`;
CREATE TABLE IF NOT EXISTS `sucursales` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) NOT NULL,
  `direccion` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `tipocliente`
--

DROP TABLE IF EXISTS `tipocliente`;
CREATE TABLE IF NOT EXISTS `tipocliente` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nombre` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `tipopago`
--

DROP TABLE IF EXISTS `tipopago`;
CREATE TABLE IF NOT EXISTS `tipopago` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nombre` varchar(50) NOT NULL,
  `descripcion` text,
  PRIMARY KEY (`id`),
  UNIQUE KEY `nombre` (`nombre`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `tipousuario`
--

DROP TABLE IF EXISTS `tipousuario`;
CREATE TABLE IF NOT EXISTS `tipousuario` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nombre` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `traslados`
--

DROP TABLE IF EXISTS `traslados`;
CREATE TABLE IF NOT EXISTS `traslados` (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `fecha_traslado` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `fecha_recepcion` datetime DEFAULT NULL,
  `sucursal_origen` int NOT NULL,
  `sucursal_destino` int NOT NULL,
  `usuario_id` int NOT NULL,
  `usuario_receptor_id` int DEFAULT NULL,
  `estado` enum('pendiente','en_transito','completado','cancelado') NOT NULL DEFAULT 'pendiente',
  `observaciones` text,
  PRIMARY KEY (`id`),
  KEY `idx_usuario_receptor` (`usuario_receptor_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `usuarios`
--

DROP TABLE IF EXISTS `usuarios`;
CREATE TABLE IF NOT EXISTS `usuarios` (
  `id` int NOT NULL AUTO_INCREMENT,
  `codigo_usuario` varchar(50) NOT NULL,
  `usuario` varchar(100) NOT NULL,
  `nombre` varchar(100) NOT NULL,
  `tipo_usuario_id` int NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `usuario` (`usuario`),
  KEY `tipo_usuario_id` (`tipo_usuario_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `ventas`
--

DROP TABLE IF EXISTS `ventas`;
CREATE TABLE IF NOT EXISTS `ventas` (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `fecha_y_hora` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `total` decimal(10,2) NOT NULL,
  `usuario_id` int NOT NULL,
  `cliente_id` int NOT NULL,
  `sucursal_id` int NOT NULL,
  `id_tipopago` int NOT NULL,
  `monto_efectivo` decimal(10,2) DEFAULT NULL,
  `monto_tarjeta` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `usuario_id` (`usuario_id`),
  KEY `cliente_id` (`cliente_id`),
  KEY `sucursal_id` (`sucursal_id`),
  KEY `id_tipopago` (`id_tipopago`),
  KEY `idx_ventas_fecha` (`fecha_y_hora`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `ventas_credito`
--

DROP TABLE IF EXISTS `ventas_credito`;
CREATE TABLE IF NOT EXISTS `ventas_credito` (
  `id` int NOT NULL AUTO_INCREMENT,
  `fecha_venta` datetime NOT NULL,
  `producto_id` int NOT NULL,
  `cantidad` int NOT NULL,
  `precio` decimal(10,2) NOT NULL,
  `total` decimal(10,2) NOT NULL,
  `usuario_id` int NOT NULL,
  `sucursal_id` int NOT NULL,
  `autorizado_por` varchar(100) NOT NULL,
  `estado` enum('pendiente','pagado') DEFAULT 'pendiente',
  `fecha_pago` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `producto_id` (`producto_id`),
  KEY `usuario_id` (`usuario_id`),
  KEY `sucursal_id` (`sucursal_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `ventas_especiales`
--

DROP TABLE IF EXISTS `ventas_especiales`;
CREATE TABLE IF NOT EXISTS `ventas_especiales` (
  `id` int NOT NULL AUTO_INCREMENT,
  `fecha_y_hora` datetime NOT NULL,
  `descripcion` varchar(255) NOT NULL,
  `precio` decimal(10,2) NOT NULL,
  `sucursal_id` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_ventas_especiales_sucursal` (`sucursal_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3;

--
-- Restricciones para tablas volcadas
--

--
-- Filtros para la tabla `compras`
--
ALTER TABLE `compras`
  ADD CONSTRAINT `fk_compras_lugarcompra` FOREIGN KEY (`id_lugarCompra`) REFERENCES `lugarcompra` (`id`);
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
