<?php
/**
 * API: Obtener Pedidos
 * Retorna los pedidos realizados, opcionalmente filtrados por sucursal
 */

header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json; charset=utf-8');

require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/branch.php';

try {
    $pdo = getDBConnection();
    
    $sucursal_id = getCurrentBranchId();
    $limit = isset($_GET['limit']) ? intval($_GET['limit']) : 10;
    
    // Construir consulta
    $sql = "SELECT 
                p.id,
                p.sucursal_id,
                s.nombre as sucursal_nombre,
                p.usuario_id,
                u.nombre as usuario_nombre,
                p.fecha_pedido,
                p.estado,
                p.observaciones,
                COUNT(dp.id) as total_productos
            FROM pedidos p
            LEFT JOIN sucursales s ON s.id = p.sucursal_id
            LEFT JOIN usuarios u ON u.id = p.usuario_id
            LEFT JOIN detalle_pedidos dp ON dp.pedido_id = p.id";
    
    if ($sucursal_id > 0) {
        $sql .= " WHERE p.sucursal_id = ?";
    }
    
    $sql .= " GROUP BY p.id
              ORDER BY p.fecha_pedido DESC
              LIMIT ?";
    
    $stmt = $pdo->prepare($sql);
    
    if ($sucursal_id > 0) {
        $stmt->execute([$sucursal_id, $limit]);
    } else {
        $stmt->execute([$limit]);
    }
    
    $pedidos = $stmt->fetchAll();
    
    // Para cada pedido, obtener sus productos
    foreach ($pedidos as &$pedido) {
        $detailStmt = $pdo->prepare("
            SELECT 
                dp.*
            FROM detalle_pedidos dp
            WHERE dp.pedido_id = ?
            ORDER BY dp.es_urgente DESC, dp.nombre_comercial ASC
        ");
        $detailStmt->execute([$pedido['id']]);
        $pedido['productos'] = $detailStmt->fetchAll();
    }
    
    sendJSON([
        'success' => true,
        'data' => $pedidos,
        'count' => count($pedidos)
    ]);
    
} catch (PDOException $e) {
    error_log("Error al obtener pedidos: " . $e->getMessage());
    sendJSON(['success' => false, 'error' => 'Error al obtener pedidos: ' . $e->getMessage()], 500);
} catch (Exception $e) {
    error_log("Error general: " . $e->getMessage());
    sendJSON(['success' => false, 'error' => 'Error general: ' . $e->getMessage()], 500);
}
