<?php
// php_logic/listar_inventario.php

ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once '../sucursal.php'; 
require_once 'db_connection.php';

header('Content-Type: application/json');

$inventario = [];

// MODIFICACIÓN: Añadimos l.id como lote_id y l.sefactura
$sql = "
    SELECT 
        l.id as lote_id,
        p.NombreComercial,
        p.laboratorio,
        p.CodigoInterno,
        l.codigo_lote,
        l.codigobarra as CodigoBarraLote,
        l.fechavencimiento,
        l.sefactura,
        i.stock_unidad_base,
        s.nombre as nombre_sucursal
    FROM inventario i
    JOIN lote l ON i.lote_id = l.id
    JOIN productos p ON l.producto_id = p.id
    JOIN sucursales s ON i.sucursal_id = s.id
    WHERE i.sucursal_id = ?
    ORDER BY l.fechavencimiento ASC
";

$stmt = $conexion->prepare($sql);

if ($stmt) {
    $id_sucursal = ID_SUCURSAL_ACTIVA;
    $stmt->bind_param("i", $id_sucursal);
    $stmt->execute();
    $resultado = $stmt->get_result();
    
    while ($fila = $resultado->fetch_assoc()) {
        $inventario[] = $fila;
    }
    $stmt->close();
} else {
    echo json_encode(['error' => 'No se pudo preparar la consulta.']);
    exit;
}

$conexion->close();

echo json_encode($inventario);